Ext.data.JsonP.sol_contract_forms_Utils({"tagname":"class","name":"sol.contract.forms.Utils","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true,"singleton":true},"files":[{"filename":"lib_sol.contract.forms.Utils.js","href":"lib_sol.contract.forms.Utils.html#sol-contract-forms-Utils"}],"author":[{"tagname":"author","name":"MW, ELO Digital Office GmbH","email":null}],"version":["1.0"],"elowf":true,"requires":["sol.common.DateUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"localCurrencySuffix","tagname":"property","owner":"sol.contract.forms.Utils","id":"property-localCurrencySuffix","meta":{"private":true}},{"name":"localizedKwlSeparator","tagname":"property","owner":"sol.contract.forms.Utils","id":"property-localizedKwlSeparator","meta":{"private":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"unitSuffix","tagname":"property","owner":"sol.contract.forms.Utils","id":"property-unitSuffix","meta":{"private":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"calcDateByDuration","tagname":"method","owner":"sol.contract.forms.Utils","id":"method-calcDateByDuration","meta":{}},{"name":"calcLocalCurrencyAmount","tagname":"method","owner":"sol.contract.forms.Utils","id":"method-calcLocalCurrencyAmount","meta":{}},{"name":"checkSource","tagname":"method","owner":"sol.contract.forms.Utils","id":"method-checkSource","meta":{}},{"name":"enableElements","tagname":"method","owner":"sol.contract.forms.Utils","id":"method-enableElements","meta":{}},{"name":"fieldExists","tagname":"method","owner":"sol.contract.forms.Utils","id":"method-fieldExists","meta":{"deprecated":{"text":"<p>Use <a href=\"#!/api/sol.common.forms.Utils-method-fieldExists\" rel=\"sol.common.forms.Utils-method-fieldExists\" class=\"docClass\">sol.common.forms.Utils.fieldExists</a> instead (from <code>common</code> version <code>1.01.002</code>)\nChecks wether a field exists</p>\n"}}},{"name":"forEachRow","tagname":"method","owner":"sol.contract.forms.Utils","id":"method-forEachRow","meta":{}},{"name":"getBaseFieldName","tagname":"method","owner":"sol.contract.forms.Utils","id":"method-getBaseFieldName","meta":{}},{"name":"getDurationNumber","tagname":"method","owner":"sol.contract.forms.Utils","id":"method-getDurationNumber","meta":{}},{"name":"getDurationUnit","tagname":"method","owner":"sol.contract.forms.Utils","id":"method-getDurationUnit","meta":{}},{"name":"getFieldNameIndex","tagname":"method","owner":"sol.contract.forms.Utils","id":"method-getFieldNameIndex","meta":{}},{"name":"getFirstStringPart","tagname":"method","owner":"sol.contract.forms.Utils","id":"method-getFirstStringPart","meta":{}},{"name":"getKwlKey","tagname":"method","owner":"sol.contract.forms.Utils","id":"method-getKwlKey","meta":{}},{"name":"getUnitFieldName","tagname":"method","owner":"sol.contract.forms.Utils","id":"method-getUnitFieldName","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"isField","tagname":"method","owner":"sol.contract.forms.Utils","id":"method-isField","meta":{}},{"name":"isFieldChanged","tagname":"method","owner":"sol.contract.forms.Utils","id":"method-isFieldChanged","meta":{}},{"name":"isFieldChangedOrFormLoaded","tagname":"method","owner":"sol.contract.forms.Utils","id":"method-isFieldChangedOrFormLoaded","meta":{}},{"name":"isValidDurationUnit","tagname":"method","owner":"sol.contract.forms.Utils","id":"method-isValidDurationUnit","meta":{}},{"name":"normalizeDurationUnit","tagname":"method","owner":"sol.contract.forms.Utils","id":"method-normalizeDurationUnit","meta":{}},{"name":"setCalculatedDate","tagname":"method","owner":"sol.contract.forms.Utils","id":"method-setCalculatedDate","meta":{}},{"name":"setDstFieldWriteableIfEmpty","tagname":"method","owner":"sol.contract.forms.Utils","id":"method-setDstFieldWriteableIfEmpty","meta":{}},{"name":"setLocalizedKwlField","tagname":"method","owner":"sol.contract.forms.Utils","id":"method-setLocalizedKwlField","meta":{}},{"name":"setReadOnly","tagname":"method","owner":"sol.contract.forms.Utils","id":"method-setReadOnly","meta":{}},{"name":"updateBaseCurrencyCodeField","tagname":"method","owner":"sol.contract.forms.Utils","id":"method-updateBaseCurrencyCodeField","meta":{}}],"code_type":"ext_define","singleton":true,"id":"class-sol.contract.forms.Utils","classIcon":"icon-singleton","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.contract.forms.Utils</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.DateUtils' rel='sol.common.DateUtils' class='docClass'>sol.common.DateUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.contract.forms.Utils.html#sol-contract-forms-Utils' target='_blank'>lib_sol.contract.forms.Utils.js</a></div></pre><div class='doc-contents'><p>Helper functions for ELOwf forms</p>\n      <p class='version-tag'>Version: <b>1.0</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-localCurrencySuffix' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.forms.Utils'>sol.contract.forms.Utils</span><br/><a href='source/lib_sol.contract.forms.Utils.html#sol-contract-forms-Utils-property-localCurrencySuffix' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.forms.Utils-property-localCurrencySuffix' class='name expandable'>localCurrencySuffix</a> : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>&quot;_LOCAL_CURR&quot;</code></p></div></div></div><div id='property-localizedKwlSeparator' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.forms.Utils'>sol.contract.forms.Utils</span><br/><a href='source/lib_sol.contract.forms.Utils.html#sol-contract-forms-Utils-property-localizedKwlSeparator' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.forms.Utils-property-localizedKwlSeparator' class='name expandable'>localizedKwlSeparator</a> : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>&quot;-&quot;</code></p></div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-property-logger\" rel=\"sol.common.ix.FunctionBase-property-logger\" class=\"docClass\">sol.common.ix.FunctionBase.logger</a>, <a href=\"#!/api/sol.common.ix.ServiceBase-property-logger\" rel=\"sol.common.ix.ServiceBase-property-logger\" class=\"docClass\">sol.common.ix.ServiceBase.logger</a></p></div></div></div><div id='property-unitSuffix' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.forms.Utils'>sol.contract.forms.Utils</span><br/><a href='source/lib_sol.contract.forms.Utils.html#sol-contract-forms-Utils-property-unitSuffix' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.forms.Utils-property-unitSuffix' class='name expandable'>unitSuffix</a> : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>&quot;_UNIT&quot;</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-calcDateByDuration' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.forms.Utils'>sol.contract.forms.Utils</span><br/><a href='source/lib_sol.contract.forms.Utils.html#sol-contract-forms-Utils-method-calcDateByDuration' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.forms.Utils-method-calcDateByDuration' class='name expandable'>calcDateByDuration</a>( <span class='pre'>startDateBaseFieldName, endDateFieldName</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Calculates a date by start date an duration ...</div><div class='long'><p>Calculates a date by start date an duration</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>startDateBaseFieldName</span> : String<div class='sub-desc'><p>Start date field name without index</p>\n</div></li><li><span class='pre'>endDateFieldName</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-calcLocalCurrencyAmount' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.forms.Utils'>sol.contract.forms.Utils</span><br/><a href='source/lib_sol.contract.forms.Utils.html#sol-contract-forms-Utils-method-calcLocalCurrencyAmount' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.forms.Utils-method-calcLocalCurrencyAmount' class='name expandable'>calcLocalCurrencyAmount</a>( <span class='pre'>amountFieldName, exchangeRateFieldName, config</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Calculates and sets the local currency amount ...</div><div class='long'><p>Calculates and sets the local currency amount</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>amountFieldName</span> : String<div class='sub-desc'><p>Amount field name</p>\n</div></li><li><span class='pre'>exchangeRateFieldName</span> : String<div class='sub-desc'><p>Exchange rate field name</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n<ul><li><span class='pre'>currencyCodeFieldName</span> : String<div class='sub-desc'><p>Amount field name</p>\n</div></li><li><span class='pre'>baseCurrencyCode</span> : String<div class='sub-desc'><p>Base currency code</p>\n</div></li><li><span class='pre'>baseCurrencyCodeFieldName</span> : String<div class='sub-desc'><p>Base currency code field name</p>\n</div></li><li><span class='pre'>localCurrencyAmountFieldName</span> : String<div class='sub-desc'><p>Local currency amount field name</p>\n</div></li><li><span class='pre'>dependentElementNames</span> : Array<div class='sub-desc'><p>This fields will be shown resp. hidden</p>\n</div></li></ul></div></li></ul></div></div></div><div id='method-checkSource' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.forms.Utils'>sol.contract.forms.Utils</span><br/><a href='source/lib_sol.contract.forms.Utils.html#sol-contract-forms-Utils-method-checkSource' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.forms.Utils-method-checkSource' class='name expandable'>checkSource</a>( <span class='pre'>source</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks if the changed input field es set ...</div><div class='long'><p>Checks if the changed input field es set</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>source</span> : Object<div class='sub-desc'><p>Changed input field</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-enableElements' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.forms.Utils'>sol.contract.forms.Utils</span><br/><a href='source/lib_sol.contract.forms.Utils.html#sol-contract-forms-Utils-method-enableElements' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.forms.Utils-method-enableElements' class='name expandable'>enableElements</a>( <span class='pre'>elementNames, show, config</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Shows or hides elements ...</div><div class='long'><p>Shows or hides elements</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>elementNames</span> : Array<div class='sub-desc'><p>Array of field names</p>\n</div></li><li><span class='pre'>show</span> : Boolean<div class='sub-desc'><p>True if the element should be shown.</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n<ul><li><span class='pre'>parentTagName</span> : String<div class='sub-desc'><p>Parent tag name</p>\n</div></li></ul></div></li></ul></div></div></div><div id='method-fieldExists' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.forms.Utils'>sol.contract.forms.Utils</span><br/><a href='source/lib_sol.contract.forms.Utils.html#sol-contract-forms-Utils-method-fieldExists' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.forms.Utils-method-fieldExists' class='name expandable'>fieldExists</a>( <span class='pre'>fieldName</span> ) : Boolean<span class=\"signature\"><span class='deprecated' >deprecated</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n        <div class='rounded-box deprecated-box deprecated-tag-box'>\n        <p>This method has been <strong>deprecated</strong> </p>\n        <p>Use <a href=\"#!/api/sol.common.forms.Utils-method-fieldExists\" rel=\"sol.common.forms.Utils-method-fieldExists\" class=\"docClass\">sol.common.forms.Utils.fieldExists</a> instead (from <code>common</code> version <code>1.01.002</code>)\nChecks wether a field exists</p>\n\n        </div>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fieldName</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-forEachRow' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.forms.Utils'>sol.contract.forms.Utils</span><br/><a href='source/lib_sol.contract.forms.Utils.html#sol-contract-forms-Utils-method-forEachRow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.forms.Utils-method-forEachRow' class='name expandable'>forEachRow</a>( <span class='pre'>indicatorColumnName, func, ctx</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Iterates over a table. ...</div><div class='long'><p>Iterates over a table.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>indicatorColumnName</span> : String<div class='sub-desc'><p>Name of a column to check if the line exists.</p>\n</div></li><li><span class='pre'>func</span> : Function<div class='sub-desc'><p>Callback function for the iteration.</p>\n</div></li><li><span class='pre'>ctx</span> : Object<div class='sub-desc'><p>Execution context.</p>\n</div></li></ul></div></div></div><div id='method-getBaseFieldName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.forms.Utils'>sol.contract.forms.Utils</span><br/><a href='source/lib_sol.contract.forms.Utils.html#sol-contract-forms-Utils-method-getBaseFieldName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.forms.Utils-method-getBaseFieldName' class='name expandable'>getBaseFieldName</a>( <span class='pre'>source</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the field name without unit suffix and trailing numbers ...</div><div class='long'><p>Returns the field name without unit suffix and trailing numbers</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>source</span> : Object|String<div class='sub-desc'><p>Source element or field name</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getDurationNumber' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.forms.Utils'>sol.contract.forms.Utils</span><br/><a href='source/lib_sol.contract.forms.Utils.html#sol-contract-forms-Utils-method-getDurationNumber' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.forms.Utils-method-getDurationNumber' class='name expandable'>getDurationNumber</a>( <span class='pre'>str</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the duration number of a duration string ...</div><div class='long'><p>Returns the duration number of a duration string</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>str</span> : String<div class='sub-desc'><p>Input string</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getDurationUnit' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.forms.Utils'>sol.contract.forms.Utils</span><br/><a href='source/lib_sol.contract.forms.Utils.html#sol-contract-forms-Utils-method-getDurationUnit' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.forms.Utils-method-getDurationUnit' class='name expandable'>getDurationUnit</a>( <span class='pre'>str</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the duration unit of a duration string ...</div><div class='long'><p>Returns the duration unit of a duration string</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>str</span> : String<div class='sub-desc'><p>Input string</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getFieldNameIndex' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.forms.Utils'>sol.contract.forms.Utils</span><br/><a href='source/lib_sol.contract.forms.Utils.html#sol-contract-forms-Utils-method-getFieldNameIndex' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.forms.Utils-method-getFieldNameIndex' class='name expandable'>getFieldNameIndex</a>( <span class='pre'>fieldName</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the field index ...</div><div class='long'><p>Returns the field index</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fieldName</span> : String<div class='sub-desc'><p>Field name</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getFirstStringPart' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.forms.Utils'>sol.contract.forms.Utils</span><br/><a href='source/lib_sol.contract.forms.Utils.html#sol-contract-forms-Utils-method-getFirstStringPart' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.forms.Utils-method-getFirstStringPart' class='name expandable'>getFirstStringPart</a>( <span class='pre'>str, separator</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the first part of a string ...</div><div class='long'><p>Returns the first part of a string</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>str</span> : String<div class='sub-desc'><p>String</p>\n</div></li><li><span class='pre'>separator</span> : String<div class='sub-desc'><p>Separator</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getKwlKey' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.forms.Utils'>sol.contract.forms.Utils</span><br/><a href='source/lib_sol.contract.forms.Utils.html#sol-contract-forms-Utils-method-getKwlKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.forms.Utils-method-getKwlKey' class='name expandable'>getKwlKey</a>( <span class='pre'>fieldName</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the keyword list key of a localized keyword list field ...</div><div class='long'><p>Returns the keyword list key of a localized keyword list field</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fieldName</span> : String<div class='sub-desc'><p>Field name</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getUnitFieldName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.forms.Utils'>sol.contract.forms.Utils</span><br/><a href='source/lib_sol.contract.forms.Utils.html#sol-contract-forms-Utils-method-getUnitFieldName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.forms.Utils-method-getUnitFieldName' class='name expandable'>getUnitFieldName</a>( <span class='pre'>fieldName</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the field name of the unit field for the given field name ...</div><div class='long'><p>Returns the field name of the unit field for the given field name</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fieldName</span> : String<div class='sub-desc'><p>Field name</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-method-initialize\" rel=\"sol.common.ix.FunctionBase-method-initialize\" class=\"docClass\">sol.common.ix.FunctionBase.initialize</a></p></div></div></div><div id='method-isField' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.forms.Utils'>sol.contract.forms.Utils</span><br/><a href='source/lib_sol.contract.forms.Utils.html#sol-contract-forms-Utils-method-isField' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.forms.Utils-method-isField' class='name expandable'>isField</a>( <span class='pre'>source, fieldName</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks wether a field exists ...</div><div class='long'><p>Checks wether a field exists</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>source</span> : Object|String<div class='sub-desc'><p>element or current field name</p>\n</div></li><li><span class='pre'>fieldName</span> : String<div class='sub-desc'><p>Field name to check</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isFieldChanged' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.forms.Utils'>sol.contract.forms.Utils</span><br/><a href='source/lib_sol.contract.forms.Utils.html#sol-contract-forms-Utils-method-isFieldChanged' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.forms.Utils-method-isFieldChanged' class='name expandable'>isFieldChanged</a>( <span class='pre'>source, fieldNames</span> ) : undefined<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks if the specific field has been changed ...</div><div class='long'><p>Checks if the specific field has been changed</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>source</span> : Object<div class='sub-desc'><p>Changed HTML element.</p>\n</div></li><li><span class='pre'>fieldNames</span> : Array<div class='sub-desc'><p>Array of field names.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>undefined</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isFieldChangedOrFormLoaded' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.forms.Utils'>sol.contract.forms.Utils</span><br/><a href='source/lib_sol.contract.forms.Utils.html#sol-contract-forms-Utils-method-isFieldChangedOrFormLoaded' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.forms.Utils-method-isFieldChangedOrFormLoaded' class='name expandable'>isFieldChangedOrFormLoaded</a>( <span class='pre'>source, fieldNames</span> ) : undefined<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks if the specific field has been changed or the form is loaded ...</div><div class='long'><p>Checks if the specific field has been changed or the form is loaded</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>source</span> : Object<div class='sub-desc'><p>Changed HTML element.</p>\n</div></li><li><span class='pre'>fieldNames</span> : Array<div class='sub-desc'><p>Array of field names.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>undefined</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isValidDurationUnit' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.forms.Utils'>sol.contract.forms.Utils</span><br/><a href='source/lib_sol.contract.forms.Utils.html#sol-contract-forms-Utils-method-isValidDurationUnit' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.forms.Utils-method-isValidDurationUnit' class='name expandable'>isValidDurationUnit</a>( <span class='pre'>str</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks whether a string is a duration ...</div><div class='long'><p>Checks whether a string is a duration</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>str</span> : String<div class='sub-desc'><p>Input string</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-normalizeDurationUnit' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.forms.Utils'>sol.contract.forms.Utils</span><br/><a href='source/lib_sol.contract.forms.Utils.html#sol-contract-forms-Utils-method-normalizeDurationUnit' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.forms.Utils-method-normalizeDurationUnit' class='name expandable'>normalizeDurationUnit</a>( <span class='pre'>durationUnit</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Normalize duration unit ...</div><div class='long'><p>Normalize duration unit</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>durationUnit</span> : String<div class='sub-desc'><p>Duration unit</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setCalculatedDate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.forms.Utils'>sol.contract.forms.Utils</span><br/><a href='source/lib_sol.contract.forms.Utils.html#sol-contract-forms-Utils-method-setCalculatedDate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.forms.Utils-method-setCalculatedDate' class='name expandable'>setCalculatedDate</a>( <span class='pre'>srcDateFieldName, durationFieldName, dstDateFieldName, params</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Calculates a date ...</div><div class='long'><p>Calculates a date</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>srcDateFieldName</span> : String<div class='sub-desc'><p>Source date field name</p>\n</div></li><li><span class='pre'>durationFieldName</span> : String<div class='sub-desc'><p>Duration field name</p>\n</div></li><li><span class='pre'>dstDateFieldName</span> : String<div class='sub-desc'><p>Destination date field name</p>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>minTermStartFieldName</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>minTermNumberFieldName</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>endOfFieldName</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>endOfUnit</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>substractOneDay</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>dontSetIfDurationIsEmpty</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>minToday</span> : String<div class='sub-desc'>\n</div></li></ul></div></li></ul></div></div></div><div id='method-setDstFieldWriteableIfEmpty' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.forms.Utils'>sol.contract.forms.Utils</span><br/><a href='source/lib_sol.contract.forms.Utils.html#sol-contract-forms-Utils-method-setDstFieldWriteableIfEmpty' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.forms.Utils-method-setDstFieldWriteableIfEmpty' class='name expandable'>setDstFieldWriteableIfEmpty</a>( <span class='pre'>srcFieldName, dstFieldName</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Set a destination field writeable if it's empty ...</div><div class='long'><p>Set a destination field writeable if it's empty</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>srcFieldName</span> : String<div class='sub-desc'><p>Source field name</p>\n</div></li><li><span class='pre'>dstFieldName</span> : String<div class='sub-desc'><p>Destination field name</p>\n</div></li></ul></div></div></div><div id='method-setLocalizedKwlField' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.forms.Utils'>sol.contract.forms.Utils</span><br/><a href='source/lib_sol.contract.forms.Utils.html#sol-contract-forms-Utils-method-setLocalizedKwlField' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.forms.Utils-method-setLocalizedKwlField' class='name expandable'>setLocalizedKwlField</a>( <span class='pre'>fieldName, key, config</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Sets a localized keyword list field ...</div><div class='long'><p>Sets a localized keyword list field</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fieldName</span> : String<div class='sub-desc'><p>Field name</p>\n</div></li><li><span class='pre'>key</span> : String<div class='sub-desc'><p>Key</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n</div></li></ul></div></div></div><div id='method-setReadOnly' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.forms.Utils'>sol.contract.forms.Utils</span><br/><a href='source/lib_sol.contract.forms.Utils.html#sol-contract-forms-Utils-method-setReadOnly' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.forms.Utils-method-setReadOnly' class='name expandable'>setReadOnly</a>( <span class='pre'>fieldName, readOnly</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Sets an input field read-only ...</div><div class='long'><p>Sets an input field read-only</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fieldName</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>readOnly</span> : Boolean<div class='sub-desc'><p>Read-only</p>\n</div></li></ul></div></div></div><div id='method-updateBaseCurrencyCodeField' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contract.forms.Utils'>sol.contract.forms.Utils</span><br/><a href='source/lib_sol.contract.forms.Utils.html#sol-contract-forms-Utils-method-updateBaseCurrencyCodeField' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contract.forms.Utils-method-updateBaseCurrencyCodeField' class='name expandable'>updateBaseCurrencyCodeField</a>( <span class='pre'>config</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Reads base currency code from configuration and writes this to map field ...</div><div class='long'><p>Reads base currency code from configuration and writes this to map field</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n<ul><li><span class='pre'>baseCurrencyCode</span> : String<div class='sub-desc'><p>Base currency code</p>\n</div></li><li><span class='pre'>baseCurrencyCodeFieldName</span> : String<div class='sub-desc'><p>Base currency code field name</p>\n</div></li></ul></div></li></ul></div></div></div></div></div></div></div>","meta":{"elowf":true,"singleton":true}});